import refreshTokenHelper from "../../../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../../../utils/errorHandlingHelper"
import fetchHelper from "../../../../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  let newObjValue = {}
  if(body.promotionGroupId) {
    newObjValue = {...newObjValue, M_PromotionGroup_ID: {
      id: body.promotionGroupId,
      tableName: 'M_PromotionGroup'
    }}
  }

  if(body.promotionId) {
    const res: any = await fetchHelper(event, 'models/m_promotionline', 'POST', token, {
      AD_Org_ID: {
        id: body.organizationId,
        tableName: 'AD_Org'
      },
      isActive: body.isActive,
      minimumAmt: body.minimumAmt,
      isMandatoryPL: body.isMandatoryPL,
      M_Promotion_ID: {
        id: body.promotionId,
        tableName: 'M_Promotion'
      },
      ...newObjValue,
      tableName: 'm_promotionline'
    })
    if(res) {
      data = res
      data['status'] = 200
      data['message'] = ''
    }
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error: any) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})